
<?php if(isset($app->versions) && !$app->versions->isEmpty() ): ?>
    <h2 class="content-heading">
        <?php echo e(__('dcm.app_version_title', ['attr' => $app->title])); ?>

        <span class="block block-themed">
        <a href="<?php echo e(route('web.app.detail.versions', $app->slug)); ?>" class="btn float-right ">
                <?php echo e(__('dcm.more')); ?> <i class="fas fa-angle-double-right"></i>
            </a>
        </span>
    </h2>
    <div class="row">
            <?php
                $myVersions =  ($limit_to ?? 0) > 0 ? $app->versions->take($limit_to) : $app->versions;
            ?>
            <?php $__currentLoopData = $myVersions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $version): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-md-5 col-lg-4">
                    <div class="card border-success mb-3" >
                        <div class="card-header">
                        <i className="fa fa-info-circle"></i>  <strong><?php echo e(__('dcm.latest_version_title',['attr' => $version->identifier])); ?></strong>
                        <span className="float-right">
                            <i className="fa fa-download"></i> <strong><?php echo e(__('dcm.apk_title')); ?></strong>
                        </span>
                        </div>
                        <div class="card-body text-dark">
                            <h6 class="card-title"> <?php echo e(str_limit($app->title, 25)); ?> </h6>
                            <p class="mb-2">
                                <i class="fa fa-fw fa-calendar-alt text-primary"></i>  <?php echo e($version->created_at); ?>

                            </p>
                            <p class="mb-2">
                                <i class="fab fa-fw fa-android text-primary"></i>  <?php echo e($version->size_formatted); ?>

                            </p>
                            <a href="<?php echo e(route('web.app.detail.download', [$app->slug, 'version' => hasher($version->id)] )); ?>"
                                class="btn btn-sm btn-block btn-secondary text-uppercase">
                                <i class="fa fa-download"></i>  <?php echo e(__('dcm.download')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php endif; ?>